*******************************************************************************
*                      68000/68010 Grundprogramm promer                       *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             Menpunkt Promer                                *
*******************************************************************************


promein:                        * Eprom und Karte auswhlen
 movea.l a0,a1                  * a0 = berschrift
 bsr headaclr                   * berschrift ausgeben
 lea txtpein(pc),a0
 moveq #$21,d0
 moveq #20,d1
 move #203,d2
 bsr textprint                  * Auswahltext
 clr d3
 move.b akteprom(a5),d3
 muls #19,d3
 lea 4(a0,d3.w),a0              * Text fr voreingestelltes Eprom
 moveq #68,d1
 moveq #23,d2
 bsr setprt                     * Voreinstellung fr Textausgabe
promein0:
 move.b (a0)+,d0
 cmp.b #10,d0                   * Bis zum Linefeed ausgeben
 beq.s promein1
 bsr cmdput                     * Zeichen ausgeben
bra.s promein0
promein1:
 lea einbuf(a5),a0
 moveq #$21,d0
 moveq #20,d1
 moveq #3,d2
 moveq #1,d3
 bsr textein                    * Einen Buchstaben lesen
 bcs carset                     * Abbruch
 move.b d5,d0
 bsr namecheck                  * In Grobuchstaben
 cmp.b #'Z',d0
 beq carset                     * 'Z' = Zurck
 cmp.b #'P',d0
 beq.s promein2                 * Alte Eprom-Einstellung
 sub.b #'A',d0                  * Mu zwischen
 bmi.s promein1                 * 0 und 14 liegen
 cmp.b #'O'-'A',d0
 bhi.s promein1
 move.b d0,akteprom(a5)         * Ergebnis 0 bis 14
promein2:
 bsr getpadr                    * a4 ist Adresse Leseroutine, Promer-Init OK
 movea.l a1,a0
 bsr headaclr                   * Nochmal berschrift
promein3:                       * Einsprung bei falschen Adressen
 lea txtp3(pc),a0
 bsr get3par                    * 3 Werte lesen
 bcs carset
 lea einbuf(a5),a0
 bsr wertmfeh                   * Letzten Wert berechnen
 bcs carset                     * Fehler
 move.l d0,d5                   * d5 = Dritter Wert
promein4:
 moveq #$22,d0
 move #150,d1
 moveq #120,d2
 moveq #28,d3
 lea einbuf(a5),a0
 move #(cpu+$30)*256,(a0)       * Voreinstellung fr CPU (1,2,4)
 move.l d5,-(a7)
 bsr readaus                    * Abstand der Bytes holen
 movem.l (a7)+,d5               * d5 nicht zerstren
 bcs carset                     * Abbruch
 lea einbuf(a5),a0
 bsr wertmfeh                   * Wert ermitteln
 bcs carset                     * Fehler
 move.l d0,d4
 beq.s promein4                 * Der Wert mu
 cmp #4,d4                      * 1, 2 oder 4 sein
 bhi.s promein4                 * Zu gro
 cmp #3,d4
 beq.s promein4                 * 3 ist nicht erlaubt
 moveq #0,d0                    * d4 ist jetzt Abstand der Bytes
 move.b akteprom(a5),d0
 move.b promtab0(pc,d0.w),d0    * Hchstes Byte des Eproms
 lsl.w #8,d0
 lsl.l #2,d0                    * Mal 1024
 subq.l #1,d0                   * -1, damit ist hchstes Bit markiert
bra carres

promtab0:                       * Tabelle der Lngen der Eproms
 dc.b 2,4,8                     * 2716,2732,2764
 dc.b 2,4,8                     * 2716,2732,2764
 dc.b 2,4,8,8,16,16,32,64,128   * 2716,2732,2764,2764,27128,27128,27256,27512
                                * 27010

promtab1:                       * Werte fr Initialisierung beim Promer2
 dc.b $28,$90,$00,$00,$90,$90   * 2716
 dc.b $28,$80,$90               * Werte frs Lesen
 dc.b $20,$90,$40,$40,$90,$90   * 2732
 dc.b $20,$80,$90
 dc.b $c0,$d2,$64,$60,$92,$92   * 2764a
 dc.b $c0,$82,$92
 dc.b $c0,$d2,$64,$60,$92,$92   * 2764b
 dc.b $c0,$82,$92
 dc.b $c0,$d2,$64,$60,$92,$92   * 27128a
 dc.b $c0,$82,$92
 dc.b $c0,$d2,$64,$60,$92,$92   * 27128b
 dc.b $c0,$82,$92
 dc.b $80,$d2,$64,$60,$92,$92   * 27256
 dc.b $80,$82,$92
 dc.b $00,$d2,$64,$60,$92,$92   * 27512
 dc.b $00,$82,$92
 dc.b $00,$fc,$60,$60,$dc,$9c   * 27010
 dc.b $00,$8c,$9c
 ds 0

getpadr:                        * Adresse fr Lesen auswhlen und Spannungen
 moveq #0,d0                    * sowie Werte fr Lesen einstellen, wenn Promer2
 move.b akteprom(a5),d0
 subq #6,d0
 bpl.s getpadr0                 * OK
 move.b #%01000000,proma2.w     * Neutral stellen, wenn Promer
 lea getprom(pc),a4             * Adresse Promer-Routine frs Lesen
rts
getpadr0:                       * Promer2
 mulu #9,d0
 lea promtab1(pc,d0.w),a3       * Adresse in der Tabelle
 move.b (a3)+,proma3.w          * Jetzt alle Werte bertragen (Adresse $83)
 move.b (a3)+,proma4.w          * $84
 move.b (a3)+,proma5.w          * $85
 move.b (a3)+,proma5.w          * $85
 move.b (a3)+,proma4.w          * $84
 move.b (a3)+,proma4.w          * $84
 lea getprom2(pc),a4            * Adresse Leseroutine
rts                             * a3 ist Zeiger auf Tabelle fr Lesewerte

getprom:                        * d5.l ist Adresse (wird um 1 erhht)
 move.b d5,proma1.w             * d0.b ist Ergebnis Wert
 move d5,d0
 lsr #8,d0
 or.b #%01000000,d0             * Neutral lassen
 move.b d0,proma2.w             * 2-tes Byte der Adresse
 addq.l #1,d5                   * Adresse erhhen
 move.b promd.w,d0              * Wert nach d0.b
rts

getprom2:                       * a3 = Adresse in Tabelle, d3 = Adresse im Eprom
 move.b d5,proma2.w             * Ergebnis d0.b = Wert
 move.l d5,d0
 lsr #8,d0
 or.b (a3)+,d0                  * Erstes Byte
 move.b d0,proma3.w             * Bits 8 bis 15 und eventuelle Spannungen
 swap d0
 or.b (a3)+,d0                  * Zweites Byte
 move.b d0,proma4.w             * Bits 16 bis 23 und eventuelle Spannungen
 addq.l #1,d5                   * Nchste Adresse
 nop                            * Sonst zu schnell
 move.b promd.w,d0              * Byte holen
 move.b (a3),proma4.w           * Neutral stellen
 subq.l #2,a3                   * Alte Adresse a3
rts

promread:                       * Eprom lesen
 lea txtp2(pc),a0
 bsr promein                    * Eprom und Karte auswhlen
 bcs carset                     * Ende
promr0:
 cmp.l d0,d6
 bhi.s promr1                   * Anfangsadresse falsch
 cmp.l d0,d7
 bls.s promr2                   * Endadresse richtig
promr1:
 bsr promein3                   * Eine Adresse falsch, deshalb neue Werte
 bcc.s promr0
bra carset
promr2:
 movea.l d5,a0                  * Ziel nach a0
 move.l d6,d5                   * Quelle nach d5
promr3:
 jsr (a4)
 move.b d0,(a0)                 * Wert aus Eprom an Adresse geben
 adda.l d4,a0                   * Nchstes Byte
 cmp.l d5,d7                    * Bis Ende erreicht
 bpl.s promr3                   * Schleife fortsetzen
bra carres                      * OK

promtab2:                       * Werte fr Promer2 beim Schreiben
 dc.b $10,$10,$81,$81,$10       * 2716
 dc.b 02,$28,$00,$10,$40,70,195+1,$00,$40,$80,$10,$90,00
 dc.b $50,$50,$b0,$b0,$50       * 2732
 dc.b 02,$20,$00,$50,$40,70,195+1,$00,$40,$90,$40,$d0,00
 dc.b $52,$52,$a4,$a6,$12       * 2764a
 dc.b 29,$c0,$40,$12,$00,217,3+1,$40,$00,$80,$10,$90,05
 dc.b $52,$52,$e4,$e6,$12       * 2764b
 dc.b 29,$c0,$40,$12,$00,217,3+1,$40,$00,$80,$10,$90,05
 dc.b $52,$52,$a4,$a6,$12       * 27128a
 dc.b 29,$c0,$40,$12,$00,217,3+1,$40,$00,$80,$10,$90,05
 dc.b $52,$52,$e4,$e6,$12       * 27128b
 dc.b 29,$c0,$40,$12,$00,229,1+1,$40,$00,$80,$10,$90,06
 dc.b $52,$52,$e4,$e6,$52       * 27256
 dc.b 29,$80,$00,$52,$40,91,0+1,$00,$40,$90,$00,$90,07
 dc.b $52,$52,$e4,$f4,$52       * 27512
 dc.b 29,$00,$00,$52,$40,91,0+1,$00,$40,$10,$c0,$d0,07
 dc.b $5c,$7c,$e8,$e8,$3c       * 27010
 dc.b 29,$00,$00,$3c,$04,91,0+1,$00,$04,$80,$10,$90,07
 ds 0

putpadr:
 lea proma1.w,a2                * Schreibadresse Low-Byte (Promer)
 lea proma2.w,a3                * Schreibadresse High-Byte (Promer)
 moveq #0,d0
 move.b akteprom(a5),d0         * Eprom-Typ holen
 subq #3,d0
 bpl.s putpadr0
 lea putproml(pc),a4            * Promer langsam
rts
putpadr0:
 subq #3,d0
 bpl.s putpadr1
 lea putproms(pc),a4            * Promer schnell
rts
putpadr1:
 mulu #18,d0
 lea promtab2(pc),a3
 adda d0,a3                     * Adresse der Epromdaten
 move.b (a3)+,proma4.w          * $84
 move.b (a3)+,proma4.w          * $84
 bsr wawa                       * Mindestens 0.3 ms warten
 move.b (a3)+,proma5.w          * $85
 bsr wawa                       * Mindestens 0.3 ms warten
 move.b (a3)+,proma5.w          * $85
 move.b (a3)+,proma4.w          * $84
 lea putprom2(pc),a4            * Promer2
 move.b #$b0,proma7.w           * Steuerwort Timer ($87)
rts
                                * Promer langsam
putproml:                       * d5 ist Adresse, d3 ist Wert
 move.b d3,promd.w              * a2, a3 sind Adressen Promer
 move d5,d2
 move.b d2,(a2)                 * Low Byte Adresse
 lsr #8,d2
 tas.b d2
 move.b d2,(a3)                 * High Byte Adresse
 or.b #%00100000,d2
 move.b d2,(a3)                 * Triggern
 and.b #%11011111,d2
 move.b d2,(a3)
 moveq #3-1,d1                  * 3*20 ms = 60 ms warten
putprl0:
 bsr sync                       * 20 ms warten
 beq.s putprl0
dbra d1,putprl0
 and.b #%00011111,d2
 move.b d2,(a3)                 * Ohne Spannung
 nop                            * Sonst zu schnell
 cmp.b promd.w,d3               * Vergleichen, ob Wert richtig gebrannt ist
 beq carres
bra carset
                                * Promer schnell
putproms:                       * d5 ist Adresse, d3 ist Wert
 moveq #29,d6                   * a2, a3 sind Adressen Promer
putprs0:
 move.b d3,promd.w              * Wert an Promer
 move d5,d1
 move.b d1,(a2)                 * Untere 8 Bit
 lsr #8,d1
putprs1:
 bsr.s putprs4                  * Programmierimpuls
 bcc.s putprs2
dbra d6,putprs1                 * Durchgangszhler
bra carset                      * Fehler !!
putprs2:
 moveq #6-1,d6                  * 5 Sicherheitsimpulse
putprs3:
 bsr.s putprs4                  * Impuls
 bcs carset                     * Doch noch Fehler !!
dbra d6,putprs3
bra carres                      * OK

putprs4:
 tas.b d1                       * Vorderstes Bit auf 1 setzen
 move.b d1,(a3)                 * Adresse bergeben
 or.b #%00100000,d1
 move.b d1,(a3)                 * Triggern
 and.b #%11011111,d1
 move.b d1,(a3)
putprs5:
 btst.b #0,(a2)                 * Warten bis Ende des Impuls
 bne.s putprs5
 and.b #%00011111,d1
 move.b d1,(a3)                 * Neutral stellen
 nop                            * Sonst zu schnell
 cmp.b promd.w,d3
 beq carres                     * OK
bra carset

putprom2:                       * d5 = Adresse, d3.b = Wert, a3 = Tabelle
 movea.l a3,a2                  * a3 nicht zerstren
 moveq #0,d6
 move.b (a2)+,d6                * Maximale Schleifendurchgnge
 move.b d3,promd.w              * Zu programmierendes Byte
 move.l d5,d1                   * Low-Byte in d5
 swap d1                        * High-Byte in d1
 move.l d5,d2
 lsr #8,d2                      * Mid-Byte in d2
 move.b d5,proma2.w             * Low-Byte einstellen ($82)
 or.b (a2)+,d2
 move.b d2,proma3.w             * Mid-Byte einstellen ($83)
 bsr putp2wait                  * Etwas warten
putpr2a:                        * Programmierschleife
 bsr.s putpr2d                  * Programmierimpuls
 bcc.s putpr2b                  * OK, weiter
dbra d6,putpr2a
bra carset                      * Fehler
putpr2b:
 moveq #0,d6
 move.b 12(a3),d6               * Anzahl der Sicherheitsimpulse
 beq carres                     * Bei 2716 und 2732 keine Sicherheitsimpulse
putpr2c:
 bsr.s putpr2d                  * Impuls
 bcs carset                     * Doch noch Fehler
dbra d6,putpr2c
bra carres                      * OK

putpr2d:                        * Eigentlicher Impuls
 move.b (a2)+,d0
 eor.b d0,d2
 move.b d2,proma3.w             * Nochmal Mid-Byte ($83)
 or.b (a2)+,d1
 move.b d1,proma4.w             * High-Byte ($84)
 move.b (a2)+,d0
 move.b (a2)+,proma6.w          * Low-Byte Zhler ($86)
 eor.b d0,d1                    * Befehl hier, wegen Geschwindigkeit
 move.b (a2)+,proma6.w          * High-Byte Zhler $(86)
 move.b d1,proma4.w             * Nochmal High-Byte ($84)
 move.b (a2)+,d0
 eor.b d0,d2                    * Mid-Byte schon fertig, dadurch schneller, wenn
putpr2e:                        * Zeit um ist
 move.b #$80,proma7.w           * Zhlerstand speichern
 tst.b proma6.w                 * Low-Byte wegwerfen
 tst.b proma6.w                 * Nur High-Byte lesen. Wenn Null, dann Zeit
 bne.s putpr2e                  * abgelaufen, da 256 us addiert wurden. So wird
                                * auf jeden Fall der Nullpunkt erkannt
 move.b d2,proma3.w             * Mid-Byte auf $83 (Bei einigen Ende Pr-Impuls)
 bsr.s putp2wait                * Etwas warten
 move.b (a2)+,d0
 eor.b d0,d1
 move.b d1,proma4.w             * High-Byte ($84) (Beim Rest hier Ende Impuls)
 bsr.s putp2wait                * Etwas warten
 move.b (a2)+,d0
 eor.b d0,d1
 move.b d1,proma4.w             * High-Byte
 bsr.s putp2wait                * Warten
 move.b (a2)+,d0
 eor.b d0,d1
 move.b d1,proma4.w             * High-Byte
 move.b (a2),d0
 eor.b d0,d1                    * High-Byte vorbereiten
 suba #9,a2                     * Alte Adresse fr eventuellen neuen Durchgang
 bsr.s putp2wait                * Etwas warten
 cmp.b promd.w,d3               * Vergleichen, ob gebrannt
 sne.b d0                       * d0 danach setzen
 move.b d1,proma4.w             * High-Byte
 tst.b d0
 beq carres                     * OK
bra carset                      * Fehler

putp2wait:                      * Ca. 2 us warten (Mit Aufruf und RTS)
 moveq #1,d0
putp2w0:
 dbra d0,putp2w0
rts

promwrite:                      * Eprom programmieren
 lea txtp1(pc),a0
 bsr promein                    * Auswahl Eprom und Karte
 bcs carset
promw0:
 cmp.l d0,d5
 bhi.s promw1                   * Zieladresse zu gro
 sub.l d6,d7                    * Anzahl Bytes
 move.l d4,d1
 lsr.l #1,d1
 lsr.l d1,d7                    * Anzahl zu schreibender Bytes  
 add.l d5,d7                    * Anfangsadresse dazu
 cmp.l d0,d7
 bls.s promw2                   * Bereich ist im Eprom
promw1:
 bsr promein3                   * Nochmal Werte lesen
 bcc.s promw0
bra carset
promw2:
 movea.l d6,a1                  * Quelladresse
 movem.l d5/a1,-(a7)            * Merken fr spter
promw3:
 jsr (a4)                       * Ein Byte holen und Adresse erhhen
 cmp.b #$ff,d0
 beq.s promw4                   * Wenn $FF, dann OK
 lea txtp4(pc),a0
 moveq #$22,d0
 moveq #95,d2
 bsr centertxt                  * Meldung, da Bereich nicht leer ist
bra.s promw5
promw4:
 cmp.l d5,d7                    * Bis letztes Byte geprft wurde
 bpl.s promw3
promw5:
 lea txtp5(pc),a0
 moveq #$32,d0
 moveq #75,d2
 bsr centertxt                  * Abfragetext frs Starten
 bsr ki
 cmp.b #'M',d0
 bne.s promw5a                  * 'M' = Ende
 addq.l #8,a7                   * Stack reinigen
bra carset
promw5a:
 cmp.b #'S',d0
 bne.s promw5                   * 'S' = Starten
 movem.l (a7),d5/a1             * Register wieder auf alten Wert
 lea txtp6(pc),a0               * d5 = Anfangsadresse Eprom
 moveq #$32,d0                  * d7 = Endadresse Eprom
 bsr centertxt                  * a1 = Anfangsadresse Ram
 bsr putpadr                    * Frs Programmieren initialisieren
promw6:
 bsr csts
 beq.s promw7                   * Weiter, wenn kein Zeichen von Tastatur
 bsr ci
 cmp.b #$1b,d0
 bne.s promw7                   * ESC ist Abbruch
 bsr getpadr                    * Auf Lesen (Spannungen)
 addq.l #8,a7                   * Stack reinigen
bra finmenue                    * Ende
promw7:
 move.b (a1),d3                 * Wert nach d3
 cmp.b #$ff,d3
 beq.s promw9                   * $FF nicht programmieren
 jsr (a4)                       * Wert Programmieren
 bcc.s promw9                   * Richtig Programmiert
 bsr promerror
 lea txtp7(pc),a0               * Fehler beim Programmieren
 moveq #$32,d0
 moveq #60,d1
 moveq #10,d2
 bsr textprint                  * Text ausgeben
 bsr ki                         * Zeichen holen
 cmp.b #'M',d0
 bne.s promw8                   * 'M', dann Ende
 bsr getpadr                    * Auf Lesen (Spannungen)
 addq.l #8,a7                   * Stack reinigen
bra finmenue                    * Ende
promw8:
 lea txtp7(pc),a0               * Sonst Text lschen und weiter programmieren
 moveq #$32,d0
 bsr erapen
 bsr textprint                  * Text lschen
promw9:
 addq.l #1,d5                   * Nchste Adresse im Eprom
 adda.l d4,a1                   * Nchste Adresse im Ram
 cmp.l d5,d7
 bpl.s promw6                   * Bis letztes Byte programmiert
 bsr getpadr
 movem.l (a7)+,d5/a1            * Werte zurck
promw10:                        * Prflesen
 jsr (a4)
 cmp.b (a1),d0                  * Wert aus Eprom an Adresse geben
 beq.s promw11                  * OK
 subq.l #1,d5                   * Alte Adresse
 bsr.s promerror                * Fehler beim Prflesen
 lea txtp8(pc),a0               * Fehler beim Programmieren
 moveq #$32,d0
 moveq #10,d2
 bsr centertxt                  * Text ausgeben
bra.s finmenue                  * Ende
promw11:
 adda.l d4,a1                   * Nchstes Byte
 cmp.l d5,d7                    * Bis Ende erreicht
 bpl.s promw10                  * Schleife fortsetzen
 lea txtp9(pc),a0               * OK
 moveq #$32,d0
 moveq #10,d2
 bsr centertxt                  * Text ausgeben, da erfolgreich programmiert
bra.s finmenue

promerror:                      * d5 = Zieladresse / a1 = Quelladresse
 lea ausbuf(a5),a0              * Adressen ausgeben
 move.l d5,d0
 bsr print6x                    * Zieladresse 5 Stellen
 move.w #'  ',(a0)+
 move.l a1,d0
 bsr print6x                    * Quelladresse 6 Stellen
 lea ausbuf+1(a5),a0
 moveq #$32,d0
 moveq #127,d1
 moveq #40,d2
bra textaus                     * Jetzt Adressen ausgeben
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               * GIDE Daten-Register
ideerr    equ $ffffff19*cpu     * GIDE Error-Register
idescnt   equ $ffffff1a*cpu     * GIDE Sektor-Zaehler
idesnum   equ $ffffff1b*cpu     * GIDE Sektor-Nummer
ideclo    equ $ffffff1c*cpu     * GIDE Zylinder Low-Byte
idechi    equ $ffffff1d*cpu     * GIDE Zylinder High-Byte
idesdh    equ $ffffff1e*cpu     * GIDE Sektor Groesse, Laufwerk, Kopf
idecmd    equ $ffffff1f*cpu     * GIDE Status(lesen) und Komandos(schreiben)

spictrl   equ $ffffff00*cpu     * SPI-Control / SPI per 